`timescale 1ns/1ns

module sum_tb;
    parameter W = 24; 
    parameter N = 1000;

    clock #(200) cclk(clk);

    logic reset,go;
    wire [W-1:0]value;

    sum #(W) sum(done,value,W'(N),go,reset,clk);

    initial begin
        $dumpfile("sum.vcd");
        $dumpvars;

        reset=1;
        #150ns;
        reset=0;
        go=1;

        #1000000ns;

        $display(value);
        $finish();
    end

    always @(posedge clk) begin
        if (done == 1)
            go = 0;
    end

endmodule;
