`timescale 1ns/1ns

module invokeSumCTL #(parameter W=1) (
    output [1:0]sumMux,
    output sumGo,
    input  sumDone,
    input  reset,
    input  clk
);
    wire [3:0]seqReg;
    wire seqUp;
    register #(4) seq(seqReg,,,
                        1'b0,1'b0,
                        1'b0,seqUp,
                        1'b0,reset,clk);

    wire sumNDone;
    notGate csumNDone(sumNDone,sumDone);
    wire t2sumNDone,t5sumNDone,t8sumNDone;
    andGate ct2sumNDone(t2sumNDone, t[2],
                                sumNDone);
    andGate ct5sumNDone(t5sumNDone, t[5],
                                sumNDone);
    andGate ct8sumNDone(t8sumNDone, t[8],
                                sumNDone);
    nor4Gate cseqNUp(seqUp,t2sumNDone,
            t5sumNDone,t8sumNDone,t[9]);

    
    wire [15:0]t;
    decoder #(4) timing(t,seqReg);

    wire sumGo;
    nor4Gate csumGo(sumGo,t[0],t[3],t[6],
                        t[9]);

    wire sumMuxUp;
    register #(2) csumMux(sumMux,,,
                            1'b0,1'b0,
                            1'b0,sumMuxUp,
                            1'b0,t[0],clk);
    orGate csumMuxUp(sumMuxUp,t[3],t[6]);
endmodule
