`timescale 1ns/1ns

module invokeSumDP #(parameter W=1) (
    output sumDone,
    input  [1:0]sumMux,
    input  sumGo,
    input  reset,
    input  clk
    );

    wire [W-1:0]options[4];
    assign options[0] = 10;
    assign options[1] = 20;
    assign options[2] = 30;
    assign options[3] = 40;

    wire [W-1:0]n;
    muxMulti #(2,W) mux(n,options,sumMux);

    wire [W-1:0] sumAnswer;
    sum #(W) sum(sumDone,sumAnswer,n,sumGo,
                reset,clk);
endmodule
