`timescale 1ns/1ns

module sumCTL (
    output done,
    output iClear,
    output iInc,
    output sumClear,
    output sumAdd,
    input  iLEn,
    input  go,
    input  reset,
    input  clk
    );


    wire [1:0]seqReg,seqIn;
    wire seqUp,seqLoad,seqReset;
    register #(2) seq(seqReg,seqIn,1'b0,
                        1'b0,1'b0,
                        1'b0,seqUp,
                        seqLoad,seqReset,
                        clk);

    assign seqLoad=0;
    or3Gate cseqReset(seqReset,reset,t0gon,t2gon);
    orGate cseqUp(seqUp,t0go,t1GT);

    wire [3:0]t;
    decoder #(2) timing(t,seqReg);

    wire gon;
    notGate cgon(gon,go);

    wire t0go,t0gon;
    andGate ct0go(t0go,t[0],go);
    andGate ct0gon(t0gon,t[0],gon);

    wire t2go,t2gon;
    andGate ct2go(t2go,t[2],go);
    andGate ct2gon(t2gon,t[2],gon);

    wire iGTn,t1LE,t1GT;
    notGate ciLEnn(iGTn,iLEn);
    andGate ct1LE(t1LE,t[1],iLEn);
    andGate ct1LEn(t1GT,t[1],iGTn);

    assign iClear = t[0];
    assign sumClear = t[0];
    orGate cdone(done,t1GT,t2go);

    assign iInc = t1LE;
    assign sumAdd = t1LE;
endmodule
