`timescale 1ns/1ns

module fiboCTL (
    output  iUp,
    output  iReset,
    output  cMux,
    output  cLoad,
    output  bLoad,
    output  bReset,
    output done,
    input  iLTn,
    input  go,
    input  reset,
    input  clk
    );

    wire [1:0]seqReg, seqIn;
    wire seqUp, seqLoad;
    register #(2) seq(seqReg,2'(1),1'b0,
                        1'b0,1'b0,
                        1'b0,seqUp,
                        seqLoad,reset,
                        clk);

    comparator #(2) cmp(,eq,,seqReg,2'(3));
    andGate cseqLoad(seqLoad,eq,t3gon);

    or3Gate cseqUp(seqUp,t[0],t1go,t2LTn);

    wire [3:0]t;
    decoder #(2) timing(t,seqReg);

    andGate cdone(done,t[2],iLTnn);

    orGate cbRreset(bReset,t[0],t3gon);
    andGate cbLoad(bLoad,t[2],iLTn);

    or3Gate ccLoad(cLoad,t[0],t2LT,t3gon);
    assign cMux = t2LT;

    orGate ciReset(iReset,t[0],t3gon);

    andGate ciUp(iUp,t[2],iLTn);

    wire gon;
    notGate cgon(gon,go);

    wire t1gon,t3gon;
    andGate ct1gon(t1gon,t[1],gon);

    wire t1go;
    andGate c1go(t1go,t[1],go);

    wire iLTnn,t1LT,t1LTn;
    notGate ciLTnn(iLTnn,iLTn);
    andGate ct1LT(t2LT,t[2],iLTn);
    andGate ct1LTn(t2LTn,t[2],iLTnn);


    wire t3go;
    andGate ct3go(t3go,t[3],go);
    andGate ct3gon(t3gon,t[3],gon);


endmodule
