`timescale 1ns/1ns

module fiboDP #(parameter W=1) (
    output [W-1:0]out,
    output iLTn,
    input  [W-1:0]n,
    input  iUp,
    input  iReset,
    input  cMux,
    input  cLoad,
    input  bLoad,
    input  bReset,
    input  clk
    );
    wire [W-1:0]bReg;
    register #(W) b(bReg,regC,1'b0,
                        1'b0,1'b0,
                        1'b0,1'b0,
                        bLoad,bReset,
                        clk);

    wire [W-1:0]optC [2], inC;
    assign optC[0] = W'(1);
    assign optC[1] = sumBC;
    muxMulti #(1,W) muxC(inC,optC,cMux);

    wire [W-1:0]regC;
    register #(W) c(regC,inC,1'b0,
                        1'b0,1'b0,
                        1'b0,1'b0,
                        cLoad,1'b0,
                        clk);


    wire [W-1:0]iReg;
    register #(W) i(iReg,W'(0),1'b0,
                            1'b0,1'b0,
                            1'b0,iUp,
                            1'b0,iReset,
                            clk);

    wire [W-1:0]sumBC;
    binaryAdder #(W) ba(,,sumBC,bReg,
                          regC,1'b0);

    comparator #(W) com(iLTn,,,iReg,n);

    assign out=bReg;

endmodule
