`timescale 1ns/1ns

module fibo_tb;
    parameter W = 24; 
    parameter N = 10;

    clock #(200) cclk(clk);

    logic reset,go;
    wire [W-1:0]value;
    wire iLTn;

    wire done;

    fibo #(W) fibo(value,done,W'(N),go,reset,clk);

    initial begin
        $dumpfile("fibo.vcd");
        $dumpvars;

        reset=1;
        go = 0;
        #150ns;
        reset=0;
        go = 1;

        #1000000ns;

                $finish();
    end

    always @(posedge clk) begin
        if (done == 1)
            go = 0;
    end

endmodule;
