`timescale 1ns/1ns

module comparator #(parameter N=1) (
  output lt, eq, gt,
  input  [N-1:0] x,
  input  [N-1:0] y
);

  wire [N-1:0] xey;
  for (genvar i = 0; i < N; i++)
    xnorGate bitsEQ(xey[i], x[i], y[i]);
  andMulti #(N) eqCalc(eq, xey);

  wire [N-1:0] xn, yn;
  for (genvar i = 0; i < N; i++) begin
    notGate n1(xn[i], x[i]);
    notGate n2(yn[i], y[i]);
  end

  wire [N-1:0] lessTot, greaterTot;
  for (genvar i = 0; i < N; i++) begin
    wire [N-1:0] less, greater;
    for (genvar j = 0; j < i; j++) begin
      assign less[j] = 1;
      assign greater[j] = 1;
    end

    andGate aLocalLt(less[i],xn[i], y[i]);
    andGate aLocalGt(greater[i],x[i], yn[i]);

    for (genvar j = i+1; j < N; j++) begin
      assign less[j] = xey[j];
      assign greater[j] = xey[j];
    end
    andMulti #(N) alt(lessTot[i], less);
    andMulti #(N) agt(greaterTot[i], greater);
  end

  orMulti #(N) alt(lt, lessTot);
  orMulti #(N) agt(gt, greaterTot);

endmodule
