`timescale 1ns/1ns


module mem #(parameter A=10,parameter W=32) (
    output logic [W-1:0]dataOut,
    input  [W-1:0]dataIn,
    input  [A-1:0]addr,
    input  write, read
    );

    logic [W-1:0]vec[2**A];

    always @(posedge read,posedge write) begin
        if (read) begin
            dataOut = vec[addr];
        end else if (write) begin
            vec[addr] = dataIn;
        end
    end


endmodule
