`timescale 1ns/1ns

module mux #(parameter SEL=1) (
  output out,
  input [2**SEL-1:0] in,
  input [SEL-1:0] s
);
  wire [2**SEL-1:0] T;
  decoder #(SEL) dec(T, s);

  wire [2**SEL-1:0] inMasked;

  for (genvar i = 0; i<2**SEL; i++)
    andGate a(inMasked[i], in[i], T[i]);

  orMulti #(2**SEL) o(out,inMasked);
endmodule
