`timescale 1ns/1ns

module registerBank
     #(parameter SEL=1, parameter WIDTH=1) (
    output [WIDTH-1:0] out,
    input  [SEL-1:0] selR,      // register number to read
    input  [WIDTH-1:0] in,      // data to store
    input  [SEL-1:0] selW,      // register number to write
    input  write,               // true for Write
    input  reset,                // Guess!
    input  clk
    );

    wire [2**SEL-1:0] load;
    decoderE #(SEL) d(load, selW, write);

    wire [WIDTH-1:0] outR [2**SEL];

    for (genvar i = 0; i < 2**SEL; i++)
        regNbit #(WIDTH) r(outR[i], in, load[i],
                                     reset, clk);

    muxMulti #(SEL, WIDTH) m(out, outR, selR);

endmodule
