`timescale 1ns/1ns

module dataPath(
    output [3:0] out,
    input [7:0] T,
    input reset,
    input clk
);

    wire [2:0] sel;
    encoder #(3) enc(sel, T);

    wire [3:0] constants[7:0];
    wire [3:0] c;
    assign constants[1] = 1;
    assign constants[2] = 2;
    assign constants[3] = 3;
    assign constants[4] = 4;
    assign constants[5] = 5;
    muxMulti #(3,4) mux(c, constants, sel);

    orMulti #(5) o1(load, T[5:1]);

    wire [3:0] sum;
    wire [3:0] adderSum;

    assign out = sum;

    binaryAdder #(4) add(,adderSum, sum, c);

    regNbit #(4) r(sum, adderSum, load, reset, clk);

endmodule
