`timescale 1ns/1ns

localparam W=32;
localparam L=1024;

module mem  (
    output logic [W-1:0]dataOut,
    input  [W-1:0]dataIn,
    input  [9:0]addr,
    input  write,
    input  read
    );

    logic [W-1:0]vec[L];

    always @(posedge read,posedge write) begin
        if (read) begin
            dataOut = vec[addr];
        end else if (write) begin
            vec[addr] = dataIn;
        end
    end


endmodule
