`timescale 1ns/1ns

module carmion1(
    output flagHalt, flagIlgl,
    output memRead, memWrite,
    output [9:0]memAddr,
    output [31:0]memIn,
    input  [31:0]memOut,
    input  reset,clk);

    wire arLoad, arLoadSel;
    wire [9:0]arOut;
    wire [31:0]drIn,drOut;
    wire drLoad;
    wire [1:0]drLoadSel;
    wire irClear, irLoad;
    wire [31:0]irOut;
    wire pcLoad, pcLoadSel, pcUp;
    wire aluEq,aluGe,aluGt,aluLe,aluLt;
    wire aluOp;

    assign memIn = drOut;
    assign drIn = memOut;
    assign memAddr = arOut;


    ctl ctl(
        aluOp,
        arLoad, arLoadSel,
        drLoad, drLoadSel,
        flagHalt, flagIlgl,
        irClear, irLoad,
        memRead, memWrite,
        pcLoad, pcLoadSel, pcUp,
        r0Load,
        r1Load,
        aluEq, aluGeu, aluGtu, aluLeu, aluLtu,
        irOut,
        reset, clk
    );
    dp  dp(
        aluEq, aluGeu, aluGtu, aluLeu, aluLtu,
        arOut, drOut, irOut,
        aluOp,
        arLoad, arLoadSel,
        drIn, drLoad, drLoadSel,
        irClear, irLoad, 
        pcLoad, pcLoadSel, pcUp, 
        r0Load,
        r1Load,
        reset, clk
    );

endmodule
