`timescale 1ns/1ns

//
// op:
//   2 - dr
//
module alu(
    output eq,geu,gtu,leu,ltu,
    output [31:0]out,
    input  [31:0]in0,in1,in2,
    input  sel0, sel1,
    input  op
);

    wire [31:0]opt0[2], opt1[2];
    wire [31:0]arg0,arg1;
    assign opt0[0] = in0;
    assign opt0[1] = in1;
    assign opt1[0] = in0;
    assign opt1[1] = in1;
    muxMulti #(1,32) c_arg0(arg0,opt0,sel0);
    muxMulti #(1,32) c_arg1(arg1,opt1,sel1);

    wire [31:0]sum;
    binaryAdder #(32) ba(,,sum,arg0,arg1,1'b0);

    wire [31:0]options[2]; 

    assign options[0] = sum;
    assign options[1] = in2;

    muxMulti #(1,32) c_out(out,options,op);

    comparator #(32) cond(ltu,eq,gtu,arg0,arg1);

    orGate c_aluLequ(leu,ltu,eq);
    orGate c_aluGequ(geu,gtu,eq);

endmodule
