`timescale 1ns/1ns

parameter opCodeHalt = 1;
parameter opCodeLw   = 2;
parameter opCodeSw   = 3;
parameter opCodeAdd  = 4;
parameter opCodeBgeu = 5;

parameter T_SHIFT = 3;
parameter T_OP    = (2**T_SHIFT);

parameter T_FETCH = 1;
parameter T_SWITCH = 4;

parameter T_ilgl = 5;
parameter T_ilglDone = T_ilgl + 1;

parameter T_halt = opCodeHalt * T_OP;
parameter T_haltDone = T_halt + 1;


parameter T_lw      = opCodeLw * T_OP;
parameter T_lwDone  = T_lw + 2;

parameter T_sw     = opCodeSw * T_OP;
parameter T_swDone = T_sw + 1;

parameter T_add     = opCodeAdd * T_OP;
parameter T_addDone = T_add;

parameter T_bgeu     = opCodeBgeu * T_OP;
parameter T_bgeuDone = T_bgeu;

module ctl(
    output aluOp,
    output arLoad, arLoadSel,
    output drLoad,
    output [1:0]drLoadSel,
    output flagHalt, flagIlgl,
    output irClear, irLoad,
    output memRead, memWrite,
    output pcLoad, pcLoadSel, pcUp, 
    output r0Load, 
    output r1Load, 
    input  aluEq, aluGeu, aluGtu, aluLeu, aluLtu,
    input  [31:0]ir,
    input  reset,
    input  clk
);
    //
    // seq
    //
    wire [(T_SHIFT+3)-1:0]seqOut,seqIn;
    wire seqClear,seqLoad,seqUp;
    register #(T_SHIFT+3) seq(
        seqOut,seqIn,,
        1'b0, 1'b0,
        1'b0,
        seqUp, seqLoad, seqClear,
        clk
    );

    wire [2**(T_SHIFT+3)-1:0]t;
    decoder #(T_SHIFT+3) timing(t,seqOut);

    wire [1:0]seqLoadSel;
    wire [T_SHIFT+3-1:0]seqOptions[4];
    assign seqOptions[0] = T_FETCH;
    assign seqOptions[1] = {ir[14:12],{(T_SHIFT)'(0)}};
    assign seqOptions[2] = T_ilglDone;
    assign seqOptions[3] = T_haltDone;
    orGate c_seqLoadSel1(seqLoadSel[1],t[T_ilglDone],t[T_haltDone]);
    orGate c_seqLoadSel0(seqLoadSel[0],t[T_SWITCH],t[T_haltDone]);
    muxMulti #(2,T_SHIFT+3) cseqIn(seqIn,seqOptions,seqLoadSel);

    wire opLegal;
    comparator #(20) c_opLegal(opLegal,,,ir[31:12], 20'(6));
    andGate c_seqSwitch(seqSwitch,t[T_SWITCH],opLegal);

    wire [5:0]allDone;
    assign allDone[0]=seqSwitch;
    assign allDone[1]=t[T_haltDone];
    assign allDone[2]=t[T_lwDone];
    assign allDone[3]=t[T_swDone];
    assign allDone[4]=t[T_addDone];
    assign allDone[5]=t[T_bgeuDone];

    orMulti #(6) c_seqLoad(seqLoad,allDone);

    orGate cseqClear(seqClear,reset,reset);

    norGate cseqUp(seqUp,seqLoad,seqClear);


    //
    // pc
    //
    andGate c_condGeu(condGeu,t[T_bgeu],aluGeu);
    orGate c_pcLoad(pcLoad,t[0],condGeu);
    assign pcLoadSel = t[T_bgeu];
    assign pcUp=t[1];


    //
    // haltReg
    //
    wire haltOut,haltUp;
    register #(1) chaltReg(
        haltOut,,,
        1'b0, 1'b0,
        1'b0, haltUp,
        1'b0, t[0],
        clk
    );
    orGate chaltUp(haltUp,t[T_ilgl],t[T_halt]);
    assign flagHalt=haltOut;

    //
    // ilglReg
    //
    wire ilglOut,ilglUp;
    register #(1) cilglReg(
        ilglOut,,,
        1'b0, 1'b0,
        1'b0,
        ilglUp, 1'b0, t[0],
        clk
    );
    assign ilglUp = t[T_ilgl];
    assign flagIlgl = ilglOut;


    //
    // ar
    //
    or3Gate carLoad(arLoad,t[1],t[T_lw],t[T_sw]);
    assign arLoadSel = t[1];


    //
    // dr
    //
    or3Gate cdrLoad(drLoad,t[2],t[T_lw+1],t[T_sw]);
    assign drLoadSel={{t[T_sw]},{ir[10]}};


    //
    // Memory
    //
    orGate cmemRead(memRead,t[2],t[T_lw+1]);
    assign memWrite = t[T_sw+1];


    //
    // ir
    //
    assign irLoad=t[3];
    assign irClear=reset;


    //
    // r[n]
    //
    assign aluOp = t[T_lw+2];

    notGate ir10n(ir10n,ir[10]);
    andGate cr0loadLw (r0LoadLw ,t[T_lw+2] ,ir10n);
    andGate cr0loadAdd(r0LoadAdd,t[T_add],ir10n);
    orGate  c_r0Load(r0Load,r0LoadLw,r0LoadAdd);

    andGate cr1loadLw (r1LoadLw, t[T_lw+2] ,ir[10]);
    andGate cr1loadAdd(r1LoadAdd,t[T_add],ir[10]);
    orGate  c_r1Load(r1Load,r1LoadLw,r1LoadAdd);
endmodule
