`timescale 1ns/1ns

module dp(
    output aluEq,aluGeu,aluGtu,aluLeu,aluLtu,
    output [9:0]  arOut,
    output [31:0] drOut,
    output [31:0] irOut,
    input  aluOp,
    input  arLoad, arLoadSel,
    input  [31:0]drInOpt,
    input  drLoad,
    input  [1:0]drLoadSel,
    input  irClear, irLoad,
    input  pcLoad, pcLoadSel, pcUp, 
    input  r0Load,
    input  r1Load,
    input  reset,
    input  clk
);
    //
    // pc
    //
    wire [9:0]pcOut,pcIn;
    register #(10) pc(
        pcOut,pcIn,,
        1'b0, 1'b0,
        1'b0,
        pcUp, pcLoad, 1'b0,
        clk
    );

    wire [9:0]pcOptions[2];
    wire [9:0]pcAdd;
    assign pcOptions[0] = 10'(512);
    assign pcOptions[1] = pcAdd;
    binaryAdder #(10) c_pcadd(,,pcAdd,pcOut,irOut[9:0],1'b0);
    muxMulti #(1,10) cpcIn(pcIn,pcOptions,pcLoadSel);

    //
    // ar
    //
    wire [9:0]arIn;
    register #(10) ar(
        arOut,arIn,,
        1'b0, 1'b0,
        1'b0, 1'b0,
        arLoad, 1'b0,
        clk
    );
    wire [9:0]arOptions[2];
    assign arOptions[0] = irOut[9:0];
    assign arOptions[1] = pcOut;
    muxMulti #(1,10) c_arIn(arIn, arOptions, arLoadSel);


    //
    // dr
    //
    wire [31:0]drIn;
    wire drLoad;
    register #(32) dr(
        drOut,drIn,,
        1'b0, 1'b0,
        1'b0, 1'b0,
        drLoad, 1'b0,
        clk
    );
    wire [31:0]drOptions[4];
    assign drOptions[0] = drInOpt;
    assign drOptions[1] = drInOpt;
    assign drOptions[2] = r0Out;
    assign drOptions[3] = r1Out;
    muxMulti #(2,32) c_drIn(drIn, drOptions, drLoadSel);

    //
    // ir
    //
    register #(32) ir(
        irOut,drOut,,
        1'b0, 1'b0,
        1'b0, 1'b0,
        irLoad, irClear,
        clk
    );


    //
    // alu
    //

    wire [31:0] r1Out,r0Out;
    register #(32) r0(
        r0Out,aluOut,,
        1'b0, 1'b0,
        1'b0, 1'b0,
        r0Load, reset,
        clk
    );
    register #(32) r1(
        r1Out,aluOut,,
        1'b0, 1'b0,
        1'b0, 1'b0,
        r1Load, reset,
        clk
    );

    wire [31:0]aluOut;
    wire aluSel0,aluSel1;
    wire aluLtu,aluEq,aluGtu,aluLeu,aluGeu;
    alu alu(aluEq,aluGeu,aluGtu,aluLeu,aluLtu,
            aluOut,
            r0Out,r1Out,drOut,
            irOut[10],irOut[11],aluOp);

endmodule
