`timescale 1ns/1ns


module mem #(parameter A=10,parameter W=32) (
    output logic [W-1:0] out,
    input  [W-1:0] in,
    input  [A-1:0] addr,
    input  write,
    input  read
    );


    logic  [W-1:0] vec [2**A];

    always @(posedge read,posedge write) begin
        if (read) begin
            out = vec[addr];
        end else if (write) begin
            vec[addr] = in;
            $display(addr, in);
        end
    end

    initial begin
        vec[0]=0;                     // sum
        vec[1]=0;                     // i
        vec[2]=10;                    // n
        vec[3]=1;                     // one
                                      // loop:
        vec[512]=32'b010000000000000; // lw  r0,sum
        vec[513]=32'b010010000000001; // lw  r1,i
        vec[514]=32'b100100000000000; // add r0,r1
        vec[515]=32'b011000000000000; // sw  r0,sum
        vec[516]=32'b010000000000011; // lw  r0,one
        vec[517]=32'b100010000000000; // add r1,r0
        vec[518]=32'b011010000000001; // sw r1,i
        vec[519]=32'b010000000000010; // lw r0,n
        vec[520]=32'b101101111110111; // bgeu r0,r1,loop
        vec[521]=32'b001000000000000; // halt
    end
endmodule
