`timescale 1ns/1ns

module encoder #(parameter SEL=1) (
  output [SEL-1:0] sel,
  input [2**SEL-1:0] d
);
  for (genvar b = 0; b < SEL; b++) begin
    wire [2**SEL-1:0] consider;
    for (genvar i = 0; i < 2**SEL; i++) begin
      if ((i & (2**b)) == 0)
        assign consider[i:i] = 0;
      else
        assign consider[i:i] = d[i:i];
      end
      orMulti #(2**SEL) o(sel[b:b],
                          consider);
  end
endmodule
