`timescale 1ns/1ns

module registerBank_tb;

    parameter WIDTH = 8; 
    parameter SEL = 4;
    parameter CYCLE = 500;

    wire clk;
    clock   #(CYCLE) c (clk);

    reg [SEL-1:0] selW;
    reg [SEL-1:0] selR;
    reg write;
    reg reset;
    reg load;
    reg [WIDTH-1:0] in;
    wire [WIDTH-1:0] out;

    registerBank #(SEL, WIDTH)
                 b(out,selR, in, selW, write, reset, clk);


    initial begin
        $dumpfile("registerBank.vcd");
        $dumpvars;

        reset = 1;
        #(CYCLE) reset = 0;

        selW = 3;
        write = 1;
        in = 5;
        selR = 4;

        #(CYCLE) write = 0;
        #(CYCLE)

        #1000
        $finish();
    end

endmodule;
