`timescale 1ns/1ns

module #(WIDTH=1) dataPath(
    output [WIDTH-1:0] out,
    output done,
    input [WIDTH-1:0] inLow,
    input [WIDTH-1:0] inHigh,
    input [7:0] T,
    input reset,
    input clk
);

    assign done = T[6:6];

    wire [2:0] sel;
    encoder #(3) enc(sel, T);

    wire [3:0] constants[7:0];
    wire [3:0] c;
    assign constants[1] = 1;
    assign constants[2] = 2;
    assign constants[3] = 3;
    assign constants[4] = 4;
    assign constants[5] = 5;
    muxMulti #(3,4) mux(c, constants, sel);

    orMulti #(5) o1(load, T[5:1]);

    wire [3:0] sum;
    wire [3:0] adderSum;

    assign out = sum;

    binaryAdder #(4) add(,adderSum, sum, c);

    regNbit #(4) r(sum, adderSum, load, reset, clk);

endmodule
